﻿Public Class Form1

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        cmbSide.SelectedIndex = 0
        numLength.Value = 20
        TruncateText()
    End Sub

    Private Sub AnyControlChanged(sender As Object, e As EventArgs) _
        Handles txtInput.TextChanged,
                numLength.ValueChanged,
                cmbSide.SelectedIndexChanged,
                chkLineByLine.CheckedChanged,
                txtIndicator.TextChanged

        TruncateText()
    End Sub

    Private Sub TruncateText()
        Dim maxLen As Integer = CInt(numLength.Value)
        Dim indicator As String = txtIndicator.Text
        Dim truncateFromRight As Boolean = (cmbSide.SelectedItem.ToString() = "Right")

        If chkLineByLine.Checked Then
            Dim lines = txtInput.Lines
            Dim outputLines As New List(Of String)

            For Each line In lines
                outputLines.Add(TruncateLine(line, maxLen, indicator, truncateFromRight))
            Next

            txtOutput.Lines = outputLines.ToArray()
        Else
            txtOutput.Text = TruncateLine(txtInput.Text, maxLen, indicator, truncateFromRight)
        End If
    End Sub

    Private Function TruncateLine(
        text As String,
        maxLen As Integer,
        indicator As String,
        truncateFromRight As Boolean
    ) As String

        If text.Length <= maxLen Then
            Return text
        End If

        Dim effectiveLen As Integer = maxLen - indicator.Length
        If effectiveLen <= 0 Then
            Return indicator.Substring(0, Math.Min(maxLen, indicator.Length))
        End If

        If truncateFromRight Then
            Return text.Substring(0, effectiveLen) & indicator
        Else
            Return indicator & text.Substring(text.Length - effectiveLen)
        End If
    End Function

End Class
